#include "mysql_field_parsers.h"

namespace NRasp {
    namespace NDumper {
        i32 ParseI32(const TString& rawInt) {
            i32 result;
            if (TryIntFromString<10>(rawInt, result)) {
                return result;
            }
            return 0;
        }

        TMaybe<i32> ParseOptionalI32(const TString& rawInt) {
            i32 result;
            if (TryIntFromString<10>(rawInt, result)) {
                return result;
            }
            return Nothing();
        }

        i32 ParseId(const TString& rawId) {
            return ParseI32(rawId);
        }

        bool ParseBool(const TString& rawBool) {
            if (rawBool.empty()) {
                return false;
            }
            return rawBool == "1";
        }

        double ParseDouble(const TString& rawDouble) {
            double result;
            if (TryFromString(rawDouble, result)) {
                return result;
            }

            return 0.0;
        }

        ui32 ParseTime(const TString& rawTime) {
            if (rawTime.empty()) {
                return 0;
            }

            ui32 h, m, s;

            Split(rawTime, ':', h, m, s);
            Y_VERIFY(h <= 24 && m < 60 && s < 60);

            return (h * 60 + m) * 60 + s;
        }
    }
}
