#pragma once

#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/string/cast.h>
#include <util/string/split.h>
#include <util/system/yassert.h>

namespace NRasp {
    namespace NDumper {
        i32 ParseI32(const TString& rawInt);
        TMaybe<i32> ParseOptionalI32(const TString& rawInt);
        i32 ParseId(const TString& rawId);
        bool ParseBool(const TString& rawBool);
        double ParseDouble(const TString& rawDouble);
        ui32 ParseTime(const TString& rawTime);
    }
}
