#include "mysql_field_parsers.h"
#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NDumper;

Y_UNIT_TEST_SUITE(MYSLQ_FIELD_PARSERS__ParseId) {
    Y_UNIT_TEST(CORRECT) {
        TString someId = "123";
        auto res = ParseId(someId.c_str());
        UNIT_ASSERT_EQUAL(res, 123);
    }
    Y_UNIT_TEST(NULL) {
        auto res = ParseId(nullptr);
        UNIT_ASSERT_EQUAL(res, 0);
    }
    Y_UNIT_TEST(BROKEN) {
        TVector<TString> examples = {"x123", "", "123d"};

        for (const auto& example : examples) {
            auto res = ParseId(example.c_str());
            UNIT_ASSERT_EQUAL(res, 0);
        }
    }
}

Y_UNIT_TEST_SUITE(MYSLQ_FIELD_PARSERS__Bool) {
    Y_UNIT_TEST(True) {
        TString someId = "1";
        auto res = ParseBool(someId.c_str());
        UNIT_ASSERT_EQUAL(res, true);
    }
    Y_UNIT_TEST(False) {
        TString someId = "0";
        auto res = ParseBool(someId.c_str());
        UNIT_ASSERT_EQUAL(res, false);
    }
    Y_UNIT_TEST(NULL) {
        auto res = ParseBool(nullptr);
        UNIT_ASSERT_EQUAL(res, false);
    }
    Y_UNIT_TEST(BROKEN) {
        TVector<TString> examples = {"x123", "", "123d"};

        for (const auto& example : examples) {
            auto res = ParseBool(example.c_str());
            UNIT_ASSERT_EQUAL(res, false);
        }
    }
}

Y_UNIT_TEST_SUITE(MYSLQ_FIELD_PARSERS__DOUBLE) {
    Y_UNIT_TEST(CORRECT) {
        TString someId = "213.5";
        auto res = ParseDouble(someId.c_str());
        UNIT_ASSERT_EQUAL(res, 213.5);
    }
    Y_UNIT_TEST(NULL) {
        auto res = ParseDouble(nullptr);
        UNIT_ASSERT_EQUAL(res, 0);
    }
    Y_UNIT_TEST(BROKEN) {
        TVector<TString> examples = {"x123", "", "123d"};

        for (const auto& example : examples) {
            auto res = ParseDouble(example.c_str());
            UNIT_ASSERT_EQUAL(res, 0.0);
        }
    }
}

Y_UNIT_TEST_SUITE(MYSLQ_FIELD_PARSERS__TIME) {
    Y_UNIT_TEST(CORRECT) {
        TVector<std::pair<TString, ui32>> tests = {
            {"01:00:00", 3600},
            {"00:01:00", 60},
            {"00:00:01", 1},
            {"00:00:00", 0},
            {"24:00:00", 86400},
        };

        for (auto& [rawTime, expected] : tests) {
            auto actual = ParseTime(rawTime.c_str());
            UNIT_ASSERT_EQUAL(actual, expected);
        }
    }
    Y_UNIT_TEST(NULL) {
        auto res = ParseTime(nullptr);
        UNIT_ASSERT_EQUAL(res, 0);
    }
}
