#include "select_query.h"

namespace NRasp {
    namespace NDumper {
        TSelectQuery::TSelectQuery(const TString& table, bool isDistinct)
            : Table_(table)
            , IsDistinct_(isDistinct)
        {
        }

        TString TSelectQuery::Str() const {
            TStringBuilder query;
            query << "SELECT ";

            if (IsDistinct_) {
                query << "DISTINCT ";
            }

            bool isFirst = true;
            for (const auto& f : Fields_) {
                if (!isFirst) {
                    query << ", ";
                }
                query << f;
                isFirst = false;
            }

            query << " FROM " << Table_ << ';';
            return query;
        }
        i32 TSelectQuery::Size() const {
            return Fields_.size();
        }
        i32 TSelectQuery::AddField(TString field) {
            i32 id = Fields_.size();
            Fields_.push_back(field);
            return id;
        }

        TFieldSelectQuery::TFieldSelectQuery(const TString& table, const TString& field)
            : TSelectQuery(table, true)
        {
            AddField(field);
        }
    }
}
