#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/string/builder.h>

namespace NRasp {
    namespace NDumper {
        class TSelectQuery {
        public:
            TSelectQuery(const TString& table, bool isDistinct = false);
            TString Str() const;
            i32 Size() const;

        protected:
            i32 AddField(TString field);

        protected:
            TVector<TString> Fields_;
            const TString Table_;
            const bool IsDistinct_;
        };

        class TFieldSelectQuery: public TSelectQuery {
        public:
            TFieldSelectQuery(const TString& table, const TString& field);
        };
    }
}
