#pragma once

#include "object_writer.h"

#include <util/generic/vector.h>

namespace NRasp {
    namespace NDumper {
        template <class T>
        class TFakeObjectWriter: public IObjectWriter<T> {
        public:
            void Write(const T& o) override {
                result.push_back(o);
            }
            const TVector<T>& GetResult() {
                return result;
            }

            const T& GetLast() {
                return result[result.ysize() - 1];
            }

        private:
            TVector<T> result;
        };
    }
}
