#include "fake_object_writer.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/list.h>
#include <util/generic/vector.h>

using namespace NRasp::NDumper;

Y_UNIT_TEST_SUITE(TFakeObjectWriter) {
    Y_UNIT_TEST(Constructor) {
        TList<TVector<TString>> queries;
        TFakeObjectWriter<int> writer;

        UNIT_ASSERT_EQUAL(writer.GetResult(), TVector<int>({}));
    }

    Y_UNIT_TEST(WriteSomeNumbers) {
        TList<TVector<TString>> queries;
        TFakeObjectWriter<int> writer;
        writer.Write(1);
        UNIT_ASSERT_EQUAL(writer.GetResult(), TVector<int>({1}));
        writer.Write(10);
        UNIT_ASSERT_EQUAL(writer.GetResult(), TVector<int>({1, 10}));
    }
}
