#pragma once

#include "object_writer.h"

#include <util/generic/string.h>
#include <library/cpp/protobuf/protofile/protofile.h>

namespace NRasp {
    namespace NDumper {
        template <class T>
        class TProtobufWriter: public IObjectWriter<T> {
        public:
            TProtobufWriter(const TString& path) {
                out = MakeHolder<TFileOutput>(path);
                implementation = MakeHolder<NFastTier::TBinaryProtoWriter<T>>();
                implementation->Open(out.Get());
            }
            void Write(const T& o) override {
                implementation->Write(o);
            };
            ~TProtobufWriter() {
                implementation->Finish();
            }

        private:
            THolder<TFileOutput> out;
            THolder<NFastTier::TBinaryProtoWriter<T>> implementation;
        };
    }
}
