#include "point_key.h"

#include <util/generic/yexception.h>
#include <util/string/cast.h>

namespace NRasp {
    namespace NDumper {
        bool operator==(const TPointKey& lft, const TPointKey& rgt) {
            return lft.Type == rgt.Type && lft.Id == rgt.Id;
        }

        EPointType ParsePointType(char rawType) {
            switch (rawType) {
                case 'c':
                    return EPointType::Settlement;
                case 's':
                    return EPointType::Station;
                default:
                    return EPointType::Unknown;
            }
        }

        bool ParsePointKey(const TString& rawValue, TPointKey* out) {
            if (rawValue.size() < 2) {
                return false;
            }
            try {
                out->Id = FromString<i32>(TStringBuf(rawValue).SubStr(1));
            } catch (yexception) {
                return false;
            }
            out->Type = ParsePointType(rawValue[0]);
            if (out->Type == EPointType::Unknown) {
                return false;
            }
            return true;
        }

        bool ParsePointKey(const TString& rawValue, EPointType expectedType, TPointKey* out) {
            if (!ParsePointKey(rawValue, out)) {
                return false;
            }
            if (out->Type != expectedType) {
                return false;
            }
            return true;
        }
    }
}
