#pragma once

#include <util/generic/string.h>

namespace NRasp {
    namespace NDumper {
        enum class EPointType {
            Unknown = 0,
            Settlement = 1,
            Station = 2,
        };

        struct TPointKey {
            EPointType Type;
            i32 Id;
        };

        bool operator==(const TPointKey& lft, const TPointKey& rgt);

        EPointType ParsePointType(char rawType);

        bool ParsePointKey(const TString& rawValue, TPointKey* out);
        bool ParsePointKey(const TString& rawValue, EPointType expectedType, TPointKey* out);
    }
}
