#include "point_key.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NDumper;

Y_UNIT_TEST_SUITE(ParsePointType){
    Y_UNIT_TEST(TryParseSettlementType){
        auto actual = ParsePointType('c');
auto expected = EPointType::Settlement;
UNIT_ASSERT_EQUAL(actual, expected);
}

Y_UNIT_TEST(TryParseStationType) {
    auto actual = ParsePointType('s');
    auto expected = EPointType::Station;
    UNIT_ASSERT_EQUAL(actual, expected);
}

Y_UNIT_TEST(TryParseUnknown) {
    auto actual = ParsePointType('g');
    auto expected = EPointType::Unknown;
    UNIT_ASSERT_EQUAL(actual, expected);
}
}
;

Y_UNIT_TEST_SUITE(ParsePointKey){
    Y_UNIT_TEST(ParseSettlment){
        TPointKey actual;
UNIT_ASSERT_EQUAL(ParsePointKey("c213", &actual), true);
TPointKey expected{EPointType::Settlement, 213};
UNIT_ASSERT_EQUAL(actual, expected);
}

Y_UNIT_TEST(ParseExactSettlment) {
    TPointKey actual;
    UNIT_ASSERT_EQUAL(ParsePointKey("c213", EPointType::Settlement, &actual), true);
    TPointKey expected{EPointType::Settlement, 213};
    UNIT_ASSERT_EQUAL(actual, expected);
}

Y_UNIT_TEST(ParseExactSettlmentButThereAreSomeStation) {
    TPointKey actual;
    UNIT_ASSERT_EQUAL(ParsePointKey("s213", EPointType::Settlement, &actual), false);
}

Y_UNIT_TEST(ParseExactSettlmentButThereAreSomeUnknown) {
    TPointKey actual;
    UNIT_ASSERT_EQUAL(ParsePointKey("x213", EPointType::Settlement, &actual), false);
}

Y_UNIT_TEST(ParseStation) {
    TPointKey actual;
    UNIT_ASSERT_EQUAL(ParsePointKey("s100", &actual), true);
    TPointKey expected{EPointType::Station, 100};
    UNIT_ASSERT_EQUAL(actual, expected);
}

Y_UNIT_TEST(ParseExactStation) {
    TPointKey actual;
    UNIT_ASSERT_EQUAL(ParsePointKey("s100", EPointType::Station, &actual), true);
    TPointKey expected{EPointType::Station, 100};
    UNIT_ASSERT_EQUAL(actual, expected);
}

Y_UNIT_TEST(ParseExactStationButThereAreSomeSettlement) {
    TPointKey actual;
    UNIT_ASSERT_EQUAL(ParsePointKey("c100", EPointType::Station, &actual), false);
}

Y_UNIT_TEST(ParseExactStationButThereAreSomeUnknown) {
    TPointKey actual;
    UNIT_ASSERT_EQUAL(ParsePointKey("x100", EPointType::Station, &actual), false);
}

Y_UNIT_TEST(ParseBrokenPoint) {
    TPointKey actual;
    UNIT_ASSERT_EQUAL(ParsePointKey("", &actual), false);
    UNIT_ASSERT_EQUAL(ParsePointKey("x", &actual), false);
    UNIT_ASSERT_EQUAL(ParsePointKey("xx", &actual), false);
    UNIT_ASSERT_EQUAL(ParsePointKey("cx", &actual), false);
}
}
;
