#include "express_to_country_loader.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TExpressToCountrySelectQuery::TExpressToCountrySelectQuery()
            : TSelectQuery("importinfo_express2country", false)
            , IdField(AddField("id"))
            , CodeReField(AddField("code_re"))
            , CountryIdField(AddField("country_id"))
            , PriorityField(AddField("priority"))
            , TimeZoneField(AddField("time_zone"))
            , CommentField(AddField("comment"))
        {
        }

        ExpressToCountryShort::ExpressToCountryShort(TString codeRe, i32 countryId, TString timeZone) {
            CodeRe = codeRe;
            CountryId = countryId;
            TimeZone = timeZone;
        }

        bool ExpressToCountryShort::operator==(const ExpressToCountryShort& target) const {
            return this->CodeRe == target.CodeRe && this->CountryId == target.CountryId && this->TimeZone == target.TimeZone;
        }

        TExpressToCountryLoader::TExpressToCountryLoader(IFetcher& fetcher)
            : Query({})
            , Fetcher_(fetcher)
        {
        }

        TVector<ExpressToCountryShort> TExpressToCountryLoader::Load() const {
            INFO_LOG << "Run the ExpressToCountry loader" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TVector<TString> row(Query.Size());
            i32 count = 0;
            TVector<ExpressToCountryShort> expressToCountries;
            while (Fetcher_.GetNext(&row)) {
                TExpressToCountry record;
                const auto codeRe = row[Query.CodeReField];
                const auto countryId = ParseId(row[Query.CountryIdField]);
                const auto timeZone = row[Query.TimeZoneField];

                expressToCountries.emplace_back(codeRe, countryId, timeZone);

                count++;
            }

            if (!count) {
                ythrow yexception() << "Express2Country has no entries.";
            }
            INFO_LOG << "The Express2Country loader has loaded: total count of entries is " << count << Endl;

            return expressToCountries;
        }
    }
}
