#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/proto/dicts/rasp/express_to_country.pb.h>

#include <util/generic/set.h>
#include <util/generic/vector.h>

namespace NRasp {
    namespace NDumper {
        class TExpressToCountrySelectQuery: public TSelectQuery {
        public:
            TExpressToCountrySelectQuery();

        public:
            const i32 IdField;
            const i32 CodeReField;
            const i32 CountryIdField;
            const i32 PriorityField;
            const i32 TimeZoneField;
            const i32 CommentField;
        };

        struct ExpressToCountryShort {
            ExpressToCountryShort(TString codeRe = nullptr, i32 countryId = 0, TString timeZone = nullptr);

            TString CodeRe;
            i32 CountryId;
            TString TimeZone;

            bool operator==(const ExpressToCountryShort& target) const;
        };

        class TExpressToCountryLoader {
        public:
            TExpressToCountryLoader(NRasp::NDumper::IFetcher& fetcher);
            TVector<ExpressToCountryShort> Load() const;

        public:
            TExpressToCountrySelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
        };
    }
}
