#include "express_to_country_loader.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/string/cast.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TExpressToCountryLoaderTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TExpressToCountryLoaderTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    THolder<TExpressToCountryLoader> Loader_;

    i32 Id;
    TString CodeRe;
    i32 CountryId;
    i32 Priority;
    TString TimeZone;
    TString Comment;

public:
    void SetUp() override {
        Fetcher_ = {};

        Loader_ = MakeHolder<TExpressToCountryLoader>(Fetcher_);
        Id = 84;
        CodeRe = "10.*";
        CountryId = 184;
        Priority = 1;
        TimeZone = "UTC";
        Comment = "comment";
    }

    TVector<TString> CreateRow() {
        return {
            ToString(Id),        // 0 id
            CodeRe,              // 1 code_re
            ToString(CountryId), // 2 country_id
            ToString(Priority),  // 3 priority
            TimeZone,            // 4 time_zone
            Comment              // 5 priority
        };
    }

    ExpressToCountryShort CreateModel() {
        return ExpressToCountryShort(CodeRe, CountryId, TimeZone);
    }

    void TestEmpty();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TExpressToCountryLoaderTest);

void TExpressToCountryLoaderTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Loader_->Load(), yexception);
}

void TExpressToCountryLoaderTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    auto result = Loader_->Load();
    UNIT_ASSERT_EQUAL(result, TVector<ExpressToCountryShort>{CreateModel()});
}
