#pragma once

#include "express_to_country_loader.h"

#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/proto/dicts/rasp/station_code.pb.h>

#include <util/generic/hash.h>
#include <util/generic/set.h>
#include <util/generic/vector.h>

#include <regex>

namespace NRasp {
    namespace NDumper {
        struct RegexExpressToCountryShort {
            RegexExpressToCountryShort(std::regex regex, ExpressToCountryShort expressToCountry);

            std::regex Regex;
            ExpressToCountryShort ExpressToCountry;
        };

        class TRailwayTimezoneProvider {
        public:
            TRailwayTimezoneProvider() = default;
            TRailwayTimezoneProvider(
                const TVector<ExpressToCountryShort>& expressToCountry,
                const THashMap<i32, THashMap<i32, TString>>& stationIdToCodes,
                const THashMap<i32, i32>& countryIdToCapitalTimeZoneId,
                const TTimeZoneProvider& timeZoneProvider);

            i32 GetTimezoneIdForStation(i32 stationId) const;

        private:
            TVector<RegexExpressToCountryShort> RegexExpressToCountry_;
            const THashMap<i32, THashMap<i32, TString>>& StationIdToCodes_;
            const THashMap<i32, i32>& CountryIdToCapitalTimeZoneId_;
            const TTimeZoneProvider& TimeZoneProvider_;

            TMaybe<ExpressToCountryShort> FindExpressToCountry(const TString& expressCode) const;
        };
    }
}
