#include "readable_timezone_dumper.h"

using namespace NJson;
using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TReadableTimezoneTankerDumper::TReadableTimezoneTankerDumper(IHttpFetcher& fetcher,
            IObjectWriter<NData::TReadableTimezone>& writer)
            : Fetcher_(fetcher)
            , Writer_(writer) {
        }

        void TReadableTimezoneTankerDumper::Dump() {
            INFO_LOG << "Run the ReadableTimezoneTankerDumper" << Endl;
            Fetcher_.InitQuery(URL_TANKER_RASP_MORDA_BACKEND_);

            TJsonValue value;
            {
                TString data;
                auto code = Fetcher_.GetData(data);
                if (code != 200) {
                    ythrow yexception() << "Query has returned code: " << code << " Skipping.";
                }

                if (!ReadJsonTree(data, &value)) {
                    ythrow yexception() << "Cannot parse json.";
                }
            }
            auto count = WriteResult(value);

            if (!count) {
                ythrow yexception() << "TReadableTimezoneTankerDumper has no records.";
            }

            INFO_LOG << "TReadableTimezoneTankerDumper has dumped: total count of entries is " << count << Endl;
        }

        i32 TReadableTimezoneTankerDumper::WriteResult(TJsonValue& value)
        {
            const TString prefixByTz = "by_tz_";
            i32 count = 0;
            auto map = value.GetMap();

            for (const auto& [lang, langValue] : map) {
                auto langMap = langValue.GetMap();
                for (const auto& [langKey, keyValue] : langMap) {
                    if (langKey.StartsWith(prefixByTz)) {
                        const auto stringLangValue = keyValue.GetStringSafe();
                        if (!stringLangValue.empty()) {
                            TReadableTimezone entry;
                            entry.SetLanguage(lang);
                            entry.SetKey(langKey);
                            entry.SetValue(stringLangValue);

                            Writer_.Write(entry);
                            count++;
                        }
                    }
                }
            }

            return count;
        }
    }
}
