#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/http_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/readable_timezone.pb.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>

#include <util/generic/vector.h>

namespace NRasp {
    namespace NDumper {
        class TReadableTimezoneTankerDumper {
        public:
            TReadableTimezoneTankerDumper(IHttpFetcher& fetcher,
                IObjectWriter<NData::TReadableTimezone>& writer);
            void Dump();

        private:
            const TString URL_TANKER_RASP_MORDA_BACKEND_ = "https://tanker-api.yandex-team.ru/keysets/json/?project-id=rasp&keyset-id=xgettext:morda_backend";
            IHttpFetcher& Fetcher_;
            IObjectWriter<NData::TReadableTimezone>& Writer_;

            i32 WriteResult(NJson::TJsonValue& value);
        };
    }
}
