#include "readable_timezone_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/tester/fabrics.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/string/cast.h>

using namespace NHttp;
using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TReadableTimezoneTankerDumperTest : public TTestBase {
private:
    UNIT_TEST_SUITE(TReadableTimezoneTankerDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestUnparsableJson);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeHttpFetcher Fetcher_;
    TFakeObjectWriter<TReadableTimezone> ObjectWriter_;
    THolder<TReadableTimezoneTankerDumper> Dumper_;

    const TString Language_ = "ru";
    const TString Key_ = "by_tz_Europe/Moscow";
    const TString Value_ = "testing";

public:
    void SetUp() override {
        ObjectWriter_ = TFakeObjectWriter<TReadableTimezone>();
        Dumper_ = MakeHolder<TReadableTimezoneTankerDumper>(Fetcher_, ObjectWriter_);
    }

    TString CreateJson() {
        return "{\"" + Language_ +"\": {\"" + Key_ + "\": \"" + Value_ +"\"}}";
    }

    TReadableTimezone CreateModel() {
        TReadableTimezone model;

        model.SetLanguage(Language_);
        model.SetKey(Key_);
        model.SetValue(Value_);

        return model;
    }

    void TestEmpty();
    void TestUnparsableJson();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TReadableTimezoneTankerDumperTest);

void TReadableTimezoneTankerDumperTest::TestEmpty() {
    Fetcher_.SetData("");
    UNIT_CHECK_GENERATED_EXCEPTION(Dumper_->Dump(), yexception);
}

void TReadableTimezoneTankerDumperTest::TestUnparsableJson() {
    Fetcher_.SetData("this is not json");
    UNIT_CHECK_GENERATED_EXCEPTION(Dumper_->Dump(), yexception);
}

void TReadableTimezoneTankerDumperTest::TestOneRecord() {
    Fetcher_.SetData(CreateJson());

    Dumper_->Dump();

    UNIT_ASSERT_STRINGS_EQUAL(
        ToJson(ObjectWriter_.GetResult()),
        ToJson(TVector<TReadableTimezone>{CreateModel()}));
}
