#include "timezone_loader.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TTimeZoneLoader::TTimeZoneLoader(NRasp::NDumper::IFetcher& fetcher, IObjectWriter<TTimeZone>& writer)
            : Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        TVector<TTimeZone> TTimeZoneLoader::Load() {
            TVector<TTimeZone> timeZones;
            TVector<TString> tables{"www_settlement", "www_station", "www_rtstation"};
            for (const auto& table_name : tables) {
                INFO_LOG << "Loading timezone from :" << table_name << Endl;
                Fetcher_.InitQuery(TFieldSelectQuery{table_name, "time_zone"}.Str());

                TVector<TString> row(1);
                while (Fetcher_.GetNext(&row)) {
                    auto timeZoneCode = row[0];
                    TryToAdd(timeZoneCode, &timeZones);
                }
            }

            if (TimeZones_.empty()) {
                ythrow yexception() << "There are no timezones.";
            }
            INFO_LOG << "Total count of timezone is " << TimeZones_.size() << Endl;
            return timeZones;
        }

        void TTimeZoneLoader::TryToAdd(const TString& code, TVector<TTimeZone>* timezones) {
            if (code.empty()) {
                return;
            }

            if (TimeZones_.count(code) == 1) {
                return;
            }

            if (!ExistsTimeZone(code)) {
                WARNING_LOG << "Can not find timezone: [" << code << "]";
                return;
            }

            TTimeZone record;
            record.SetId(static_cast<i32>(TimeZones_.size()));
            record.SetCode(code);
            Writer_.Write(record);
            timezones->push_back(record);
            TimeZones_.insert(code);
        }
    }
}
