#pragma once

#include "helpers.h"

#include <library/cpp/logger/global/global.h>

#include <util/generic/set.h>
#include <util/generic/string.h>

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/timezone.pb.h>

namespace NRasp {
    namespace NDumper {
        class ITimeZoneLoader {
        public:
            virtual TVector<NData::TTimeZone> Load() = 0;
            virtual ~ITimeZoneLoader() {
            }
        };

        class TTimeZoneLoader: public ITimeZoneLoader {
        public:
            TTimeZoneLoader(NRasp::NDumper::IFetcher& fetcher, IObjectWriter<NData::TTimeZone>& writer);
            TVector<NData::TTimeZone> Load() override;

        private:
            void TryToAdd(const TString& code, TVector<NData::TTimeZone>* timezones);

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TTimeZone>& Writer_;
            TSet<TString> TimeZones_;
        };
    }
}
