#include "timezone_provider.h"
#include "helpers.h"

using namespace NRasp::NData;
namespace NRasp {
    namespace NDumper {
        TTimeZoneProvider::TTimeZoneProvider(const TVector<TTimeZone>& timeZones, const TString& defaultTimezone)
            : DefaultTimeZoneCode_(defaultTimezone)
        {
            Y_ENSURE_EX(ExistsTimeZone(DefaultTimeZoneCode_), TUnknownDefaultTimeZone());
            Fill(timeZones);
            Y_ENSURE_EX(TimeZoneCodeToId_.count(DefaultTimeZoneCode_) == 1, TUnpresentDefaultTimeZone());
        }

        i32 TTimeZoneProvider::GetTimeZoneId(const TString& code) const {
            auto it = TimeZoneCodeToId_.find(code);
            if (it != TimeZoneCodeToId_.end()) {
                return TimeZoneCodeToId_.at(code);
            }
            return GetTimeZoneId(DefaultTimeZoneCode_);
        }

        const NDatetime::TTimeZone& TTimeZoneProvider::GetTimeZone(i32 id) const {
            auto it = IdToTimeZone_.find(id);
            if (it == IdToTimeZone_.end()) {
                return IdToTimeZone_.at(GetTimeZoneId(DefaultTimeZoneCode_));
            }
            return it->second;
        }

        void TTimeZoneProvider::Fill(const TVector<TTimeZone>& timeZones) {
            for (auto& t : timeZones) {
                auto& code = t.GetCode();
                auto id = t.GetId();
                if (!ExistsTimeZone(code)) {
                    WARNING_LOG << "Can not find timezone: [" << code << "]";
                    return;
                }
                TimeZoneCodeToId_[code] = t.GetId();
                IdToTimeZone_[id] = NDatetime::GetTimeZone(code);
            }
        }
    }
}
