#pragma once

#include <util/system/types.h>
#include <util/generic/string.h>
#include <util/generic/map.h>
#include <library/cpp/logger/global/global.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_helpers.h>
#include <travel/proto/dicts/rasp/timezone.pb.h>
#include <library/cpp/timezone_conversion/civil.h>
#include <util/generic/yexception.h>
#include <algorithm>

namespace NRasp {
    namespace NDumper {
        class TUnknownDefaultTimeZone: public yexception {};
        class TUnpresentDefaultTimeZone: public yexception {};

        class TTimeZoneProvider {
        public:
            TTimeZoneProvider() = default;
            TTimeZoneProvider(const TVector<NData::TTimeZone>& timeZones, const TString& defaultTimezone);
            i32 GetTimeZoneId(const TString& code) const;
            const NDatetime::TTimeZone& GetTimeZone(i32 id) const;

        private:
            void Fill(const TVector<NData::TTimeZone>& timeZones);

        private:
            const TString DefaultTimeZoneCode_;
            TMap<TString, i32> TimeZoneCodeToId_;
            TMap<i32, NDatetime::TTimeZone> IdToTimeZone_;
        };
    }
}
