#include "title_common.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        bool ParseTitleCommon(const i32 threadId, const TString& rawTitleCommon, const TSet<i32>& stationIds, const TSet<i32>& settlementIds, TThreadTitle* title) {
            TStringStream str(rawTitleCommon);
            auto root = NJson::ReadJsonTree(&str, true).GetMap();

            // TODO: title->SetType, title->SetTransportType

            title->SetIsCombined(root.contains("is_combined"));
            title->SetIsRing(root.contains("add_ring") ||
                             root.contains("add_circular") ||
                             root.contains("add_circular_mta"));

            for (const auto& rawPart : root.at("title_parts").GetArray()) {
                auto& part = *title->AddTitleParts();
                const auto& partType = rawPart.GetType();
                if (partType == NJson::EJsonValueType::JSON_STRING) {
                    const auto& partValue = rawPart.GetString();
                    TPointKey pointKey;
                    if (!ParsePointKey(partValue, &pointKey)) {
                        WARNING_LOG << "Can not parse title common, because pointKey has wrong format [" << partValue << "] for thread with id: [" << threadId << "]" << Endl;
                        return false;
                    }

                    switch (pointKey.Type) {
                        case EPointType::Settlement:
                            if (settlementIds.count(pointKey.Id) == 0) {
                                WARNING_LOG << "Can not parse title common, because settlement id [" << pointKey.Id << "] has not exist for thread with id: [" << threadId << "]" << Endl;
                                return false;
                            }
                            part.SetSettlementId(pointKey.Id);
                            break;
                        case EPointType::Station:
                            if (stationIds.count(pointKey.Id) == 0) {
                                WARNING_LOG << "Can not parse title common, because station id [" << pointKey.Id << "] has not exist for thread with id: [" << threadId << "]" << Endl;
                                return false;
                            }
                            part.SetStationId(pointKey.Id);
                            break;
                        default:
                            WARNING_LOG << "Can not parse title common, because pointKey has unexpected type [" << partValue << "] for thread with id: [" << threadId << "]" << Endl;
                            return false;
                    }
                } else if (partType == NJson::EJsonValueType::JSON_MAP) {
                    const auto& partValue = rawPart.GetMap();
                    TPointKey settlementPointKey, stationPointKey;
                    auto rawSettlementPointKey = partValue.at("settlement").GetString();
                    if (!ParsePointKey(rawSettlementPointKey, EPointType::Settlement, &settlementPointKey)) {
                        WARNING_LOG << "Can not parse title common, because pointKey has wrong format [" << rawSettlementPointKey << "] for thread with id: [" << threadId << "]" << Endl;
                        return false;
                    } else {
                        if (settlementIds.count(settlementPointKey.Id) == 0) {
                            WARNING_LOG << "Can not parse title common, because settlement id [" << settlementPointKey.Id << "] has not exist for thread with id: [" << threadId << "]" << Endl;
                            return false;
                        }
                    }
                    auto rawStationPointKey = partValue.at("station").GetString();
                    if (!ParsePointKey(rawStationPointKey, EPointType::Station, &stationPointKey)) {
                        WARNING_LOG << "Can not parse title common, because pointKey has wrong format [" << rawStationPointKey << "] for thread with id: [" << threadId << "]" << Endl;
                        return false;
                    } else {
                        if (stationIds.count(stationPointKey.Id) == 0) {
                            WARNING_LOG << "Can not parse title common, because station id [" << stationPointKey.Id << "] has not exist for thread with id: [" << threadId << "]" << Endl;
                            return false;
                        }
                    }
                    part.SetSettlementId(settlementPointKey.Id);
                    part.SetStationId(stationPointKey.Id);
                } else {
                    WARNING_LOG << "Can not parse title common, because thread part type [" << partType << "] has not exist for thread with id: [" << threadId << "]" << Endl;
                    return false;
                }
            }
            return true;
        }
    }
}
