#include "vehicle_producer_provider.h"

namespace NRasp {
    namespace NDumper {
        TVehicleProducerSelectQuery::TVehicleProducerSelectQuery()
                : TSelectQuery("www_vehicleproducer", false)
                , IdField(AddField("id"))
                , TitleField(AddField("title"))
        {
        }

        TVehicleProducerProvider::TVehicleProducerProvider(NRasp::NDumper::IFetcher& fetcher)
                : Query({})
                , Fetcher_(fetcher)
        {
        }

        void TVehicleProducerProvider::Init() {
            INFO_LOG << "Load vehicle producers" << Endl;
            Fetcher_.InitQuery(Query.Str());
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                VehicleProducers_[ParseId(row[Query.IdField])] = row[Query.TitleField];
            }

            INFO_LOG << "Loaded " << VehicleProducers_.size() << " vehicle producers" << Endl;
        }

        TString TVehicleProducerProvider::GetVehicleProducerTitle(i32 id) {
            return VehicleProducers_[id];
        }
    }
}
