#pragma once

#include <util/generic/map.h>
#include <util/generic/string.h>
#include <util/system/types.h>

#include <library/cpp/logger/global/global.h>

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>

namespace NRasp {
    namespace NDumper {
        class TVehicleProducerSelectQuery: public TSelectQuery {
        public:
            TVehicleProducerSelectQuery();

        public:
            const i32 IdField;
            const i32 TitleField;
        };

        class TVehicleProducerProvider {
        public:
            TVehicleProducerProvider(NRasp::NDumper::IFetcher& fetcher);
            void Init();
            TString GetVehicleProducerTitle(i32 id);

        public:
            const TVehicleProducerSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            TMap<i32, TString> VehicleProducers_;
        };
    }
}
