#include "vehicle_producer_provider.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NDumper;

class TVehicleProducerProviderTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TVehicleProducerProviderTest);
    UNIT_TEST(TestExists);
    UNIT_TEST(TestNotExists);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    THolder<TVehicleProducerProvider> Provider_;

public:
    void SetUp() override {
        Fetcher_ = {};
        Fetcher_.Add({CreateRow()});

        Provider_ = MakeHolder<TVehicleProducerProvider>(Fetcher_);
    }

    TVector<TString> CreateRow() {
        return {
            "11",              // id
            "Сухой",           // title
        };
    }

    void TestExists();
    void TestNotExists();
};

UNIT_TEST_SUITE_REGISTRATION(TVehicleProducerProviderTest);

void TVehicleProducerProviderTest::TestExists() {
    Provider_->Init();
    UNIT_ASSERT_EQUAL(Provider_->GetVehicleProducerTitle(11), "Сухой");
}

void TVehicleProducerProviderTest::TestNotExists() {
    Provider_->Init();
    UNIT_ASSERT_STRINGS_EQUAL(Provider_->GetVehicleProducerTitle(1), "");
}
