#include "year_mask.h"

#include <string>
#include <array>
#include <algorithm>
#include <util/string/cast.h>

namespace NRasp {
    namespace NDumper {
        i32 ParseMonthMask(TStringBuf binString) {
            i32 result = 0;
            i32 acc = 1;
            for (ui32 i = 0; i < MAX_DAY_PER_MONTH; ++i, acc <<= 1) {
                if (binString[i] == '1') {
                    result += acc;
                }
            }
            return result;
        }

        TYearMask ParseYearMask(const TString& rawMask) {
            TYearMask result = {};
            TStringBuf mask(rawMask);
            for (ui32 i = 0; i < MONTH_COUNT; ++i) {
                result[i] = ParseMonthMask(mask.substr(i * MAX_DAY_PER_MONTH, MAX_DAY_PER_MONTH));
            }
            return result;
        }
    }
}
