#include "year_mask.h"

#include <library/cpp/testing/unittest/registar.h>
#include <array>

using namespace NRasp::NDumper;
using namespace ::google::protobuf;

Y_UNIT_TEST_SUITE(PARSE_YEAR_MASK) {
    Y_UNIT_TEST(SomeMask) {
        TString mask{
            "0000000000000000000000000000000"
            "1000000000000000000000000000000"
            "0100000000000000000000000000000"
            "1100000000000000000000000000000"
            "0010000000000000000000000000000"
            "1010000000000000000000000000000"
            "0110000000000000000000000000000"
            "1110000000000000000000000000000"
            "0001000000000000000000000000000"
            "1001000000000000000000000000000"
            "0101000000000000000000000000000"
            "1101000000000000000000000000000"};

        TYearMask expectedMaskValues{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        TYearMask actualMask = ParseYearMask(mask.c_str());
        UNIT_ASSERT_VALUES_EQUAL(actualMask, expectedMaskValues);
    }
    Y_UNIT_TEST(EmptyMask) {
        TString mask{
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"
            "0000000000000000000000000000000"};

        TYearMask expectedMaskValues{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        TYearMask actualMask = ParseYearMask(mask.c_str());
        UNIT_ASSERT_VALUES_EQUAL(actualMask, expectedMaskValues);
    }
    Y_UNIT_TEST(MaxMask) {
        TString mask{
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"
            "1111111111111111111111111111111"};

        i32 cellValue = std::numeric_limits<i32>::max();
        TYearMask expectedMaskValues{};
        expectedMaskValues.fill(cellValue);
        TYearMask actualMask = ParseYearMask(mask.c_str());
        UNIT_ASSERT_VALUES_EQUAL(actualMask, expectedMaskValues);
    }
}
