# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from os.path import join as path_join

from travel.rasp.rasp_data.resource_checker.data_provider import DataProvider
from travel.rasp.rasp_data.resource_checker.checker import run

logging.basicConfig(level=logging.INFO)
log = logging.getLogger()

RESOURCES_DIR = '/app/data'
REPOS = ('country', 'settlement')


def main():
    repo_pathes = {x: path_join(RESOURCES_DIR, '{}.bin'.format(x)) for x in REPOS}
    data_provider = DataProvider(repo_pathes)

    check_errors = run(data_provider, log)
    log.info('-'*30)
    log.info('{} check error(s):'.format(len(check_errors)))
    for check_error in check_errors:
        log.info(check_error)
    log.info('-'*30)


if __name__ == '__main__':
    main()
