# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from logging import Logger
from typing import AnyStr, Callable, List, Optional

from travel.rasp.rasp_data.resource_checker.data_provider import DataProvider
from travel.rasp.rasp_data.resource_checker.check_exception import CheckException
from travel.rasp.rasp_data.resource_checker.checks import CHECKS


CHECK_TYPE = Callable[[DataProvider, Logger], None]


def run_check(check, data_provider, log):
    # type: (CHECK_TYPE, DataProvider, Logger) -> Optional[AnyStr]

    log.info('Start {}'.format(check.__name__))
    try:
        check(data_provider, log)
    except CheckException as ex:
        log.error(str(ex))
        return '{}: {}'.format(check.__name__, str(ex))
    except Exception:
        msg = 'Unhandled exception'
        log.exception(msg)
        return '{}: {}'.format(check.__name__, msg)
    finally:
        log.info('Finish {}'.format(check.__name__))


def run(data_provider, log):
    # type: (DataProvider, Logger) -> List[AnyStr]

    data_provider.load()

    check_errors = []
    for check in CHECKS:
        check_error = run_check(check, data_provider, log)
        if check_error is not None:
            check_errors.append(check_error)

    return check_errors
