# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from typing import AnyStr, Dict

from travel.library.python.dicts.country_repository import CountryRepository
from travel.library.python.dicts.settlement_repository import SettlementRepository


class DataProvider(object):
    def __init__(self, repo_pathes):
        # type: (Dict[AnyStr, AnyStr])-> DataProvider

        self._repo_pathes = repo_pathes

        self.country_repo = CountryRepository()
        self.settlement_repo = SettlementRepository()

    def load(self):
        self.country_repo.load_from_file(self._repo_pathes['country'])
        self.settlement_repo.load_from_file(self._repo_pathes['settlement'])
