# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import os

log = logging.getLogger(__name__)
log.setLevel(logging.INFO)


def load_project():
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'local_settings')

    log.info('Loading Django with env: YENV_TYPE={}; RASP_SERVICE_INSTANCE={}; DJANGO_SETTINGS_MODULE={}'.format(
        os.getenv('YENV_TYPE'),
        os.getenv('RASP_SERVICE_INSTANCE'),
        os.getenv('DJANGO_SETTINGS_MODULE'),
    ))

    import django
    django.setup()

    from common.db.switcher import switcher
    log.info('Calling sync_db')
    switcher.sync_db()
    log.info('sync_db done')
