# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from datetime import timedelta

from common.precache.backend import setup_precache
from travel.rasp.library.python.common23.logging import create_current_file_run_log
from travel.rasp.library.python.common23.date import environment
from mapping.generators import livemap

log = logging.getLogger(__name__)


def run(duration, map_generator):
    setup_precache(logger=log)

    create_current_file_run_log()

    now = environment.now_aware()
    expires_at = now + timedelta(minutes=duration)

    if map_generator == 'bus':
        livemap.generate_bus_paths(now, expires_at)
    elif map_generator == 'train':
        livemap.generate_train_paths(now, expires_at)
