# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import struct

from django.conf import settings

from common.models.pathfinder_maps import PathfinderMapsNearestSettlement
from travel.proto.dicts.rasp.pathfinder_maps_nearest_settlement_pb2 import TPathfinderMapsNearestSettlement

UINT32 = struct.Struct('<I')

log = logging.getLogger(__name__)


def build_protobuf(nearest_settlement):
    log.info('Building {} -> {}'.format(nearest_settlement.settlement_from, nearest_settlement.settlement_to))
    nearest_settlement_pb = TPathfinderMapsNearestSettlement()
    nearest_settlement_pb.SettlementFrom = nearest_settlement.settlement_from.id
    nearest_settlement_pb.SettlementTo = nearest_settlement.settlement_to.id
    return nearest_settlement_pb


def dump_data(nearest_settlements):
    with open(settings.PATHFINDER_MAPS_NEAREST_SETTLEMENT_FILENAME, 'wb') as f:
        for nearest_settlement in nearest_settlements:
            nearest_settlement_pb = build_protobuf(nearest_settlement)
            f.write(UINT32.pack(nearest_settlement_pb.ByteSize()))
            f.write(nearest_settlement_pb.SerializeToString())


def run():
    nearest_settlements = list(PathfinderMapsNearestSettlement.objects.all())
    dump_data(nearest_settlements)


if __name__ == '__main__':
    run()
