# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from common.apps.archival_data.clean import clean
from common.apps.archival_data.generation import SettlementsDataGenerator, SearchDataGenerator
from common.maintenance.models import Flag
from common.precache.backend import setup_precache

log = logging.getLogger(__name__)


def run():
    if bool(Flag.objects.get(name='maintenance').state):
        log.info('maintenance in process')
        return

    setup_precache(logger=log)
    clean()
    SettlementsDataGenerator().generate(use_baris=True)
    SearchDataGenerator().generate(use_baris=True)


if __name__ == '__main__':
    run()
