# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from datetime import timedelta

from travel.rasp.library.python.common23.date import environment
from common.apps.im_logs.models import group_im_table


log = logging.getLogger(__name__)


def run():
    table_date = environment.today() - timedelta(days=1)

    log.info('Group IM log data for {}'.format(table_date))
    group_im_table(table_date)
    log.info('Run done')


if __name__ == '__main__':
    run()
