# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

"""Скрипт кэширует результаты экспорта гортранса в файлы"""

import logging

from travel.rasp.rasp_scripts.scripts.long_haul.export import SUPPORTED_VERSIONS, export
from travel.rasp.rasp_scripts.scripts.long_haul.export.validation import remove_db
from common.db.mds.clients import mds_s3_common_client
from travel.rasp.library.python.common23.logging import create_current_file_run_log

logger = logging.getLogger(__name__)


def upload_dir_mds(path):
    logger.info('Load export to MDS')
    mds_s3_common_client.upload_directory(path, 'rasp-long-haul', skip_empty_files=False)
    logger.info('Export is loaded to MDS')


def run(verbose=True, skip=None):
    create_current_file_run_log()

    versions = SUPPORTED_VERSIONS

    try:
        remove_db()
    except OSError:
        pass

    try:
        logger.info('long_haul export started')
        export(verbose=verbose,
               versions=versions,
               skip_generators=skip)
        logger.info('long_haul export completed')
    except Exception as ex:
        logger.error('long_haul error: {}'.format(repr(ex)))
    finally:
        try:
            remove_db()
        except OSError:
            pass


if __name__ == '__main__':
    run()
