# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
import os

from django.conf import settings

from common.db.switcher import switcher
from travel.rasp.library.python.common23.logging import create_current_file_run_log

from travel.rasp.rasp_scripts.scripts.pathfinder.gen_baris_thegraph import gen_thegraph_from_baris
from travel.rasp.rasp_scripts.scripts.pathfinder.gen_rasp_db_thegraph import gen_thegraph_from_rasp_db
from travel.rasp.rasp_scripts.scripts.pathfinder.gen_maps import generate_map_files, generate_currency_map
from travel.rasp.rasp_scripts.scripts.pathfinder.tmpfiles import clean_temp


log = logging.getLogger(__name__)

DATA_PATH = os.path.join(settings.PATHFINDER_DATA_PATH, switcher.get_db_alias())

# проверяем, что директория существует, иначе создаем ее
if not os.path.exists(DATA_PATH):
    os.makedirs(DATA_PATH)


@clean_temp
def run(thegraph_only=False):
    path = DATA_PATH

    generate_currency_map(path)
    if not thegraph_only:
        generate_map_files(path)

    log.info('Generation of the file thegraph')
    thegraph_path = os.path.join(path, 'thegraph')

    gen_thegraph_from_rasp_db(thegraph_path)
    gen_thegraph_from_baris(thegraph_path)

    # обновляем таймстэмп, делаем это после обновления всех файлов
    open(os.path.join(path, 'timestamp'), 'w').close()


def main():
    create_current_file_run_log()

    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', dest='verbose', action='store_true')
    parser.add_argument('-t', '--thegraph-only', dest='thegraph_only', action='store_true')
    args = parser.parse_args()

    run(thegraph_only=args.thegraph_only)


if __name__ == '__main__':
    main()
