# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from datetime import timedelta

from django.conf import settings

from common.utils.date import daterange


def get_to_pathfinder_year_days_converter(today):
    start_date = today - timedelta(days=settings.DAYS_TO_PAST)
    feb_days = 29 if any(mask_date.month == 2 and mask_date.day == 29
                         for mask_date in daterange(start_date, start_date + timedelta(days=365))) else 28

    def to_pathfinder_year_days(mask):
        year_days = unicode(mask)
        return ''.join([
            year_days[:31],  # jan
            year_days[31: 31 + feb_days],  # feb
            year_days[31 * 2: 31 * 2 + 31],  # mar
            year_days[31 * 3: 31 * 3 + 30],  # apr
            year_days[31 * 4: 31 * 4 + 31],  # may
            year_days[31 * 5: 31 * 5 + 30],  # jun
            year_days[31 * 6: 31 * 6 + 31],  # jul
            year_days[31 * 7: 31 * 7 + 31],  # aug
            year_days[31 * 8: 31 * 8 + 30],  # sep
            year_days[31 * 9: 31 * 9 + 31],  # oct
            year_days[31 * 10: 31 * 10 + 30],  # nov
            year_days[31 * 11: 31 * 11 + 31],  # dec
        ])

    return to_pathfinder_year_days
