# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from collections import namedtuple
from datetime import timedelta

from common.utils.date import daterange


class MaskBounds(namedtuple('MaskBounds', ['start_date', 'end_date'])):
    __slots__ = ()

    def __init__(self, start_date, end_date):
        assert start_date
        assert end_date

        super(MaskBounds, self).__init__(start_date, end_date)

    def __repr__(self):
        return 'MaskBounds({!r}, {!r})'.format(self.start_date, self.end_date)

    def get_narrowed(self, start_date=None, end_date=None):
        if start_date:
            start_date = start_date if start_date >= self.start_date else self.start_date
        else:
            start_date = self.start_date

        if end_date:
            end_date = end_date if end_date <= self.end_date else self.end_date
        else:
            end_date = self.end_date

        return MaskBounds(start_date, end_date)

    def iter_dates(self):
        return daterange(self.start_date, self.end_date + timedelta(1))
