# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from common.models.geo import Country
from travel.rasp.library.python.common23.date import environment
from common.utils.date import RunMask
from travel.rasp.rasp_scripts.scripts.pathfinder.mask_builder.bounds import MaskBounds
from travel.rasp.rasp_scripts.scripts.pathfinder.mask_builder.standard_builders import mask_from_days_of_week, odd_mask, even_mask, daily_mask, gap_days_mask, \
    mask_from_day_condition, one_day_mask
from travel.rasp.rasp_scripts.scripts.pathfinder.mask_builder.ycal_builders import ycal_workdays_mask, ycal_weekends_and_holidays_mask, ycal_holidays_mask


class MaskBuilder(object):
    def __init__(self, lower_bound, upper_bound, today=None, country=None, **kwargs):

        self.base_bounds = MaskBounds(lower_bound, upper_bound)
        self.today = today or environment.today()
        self.country = country or Country.objects.get(id=Country.RUSSIA_ID)

    def get_bounds(self, start_date, end_date):
        return self.base_bounds.get_narrowed(start_date, end_date)

    def mask_from_days_of_week(self, days, start_date=None, end_date=None):
        u"""
        Делаем маску из формата 1234567
        Воскресенье это 7
        """

        return mask_from_days_of_week(self.get_bounds(start_date, end_date), days, today=self.today)

    def odd_mask(self, start_date=None, end_date=None):
        return odd_mask(self.get_bounds(start_date, end_date), today=self.today)

    def even_mask(self, start_date=None, end_date=None):
        """
        По четным дням
        :param start_date:
        :param end_date:
        :return:
        """
        return even_mask(self.get_bounds(start_date, end_date), today=self.today)

    def empty_mask(self):
        return RunMask(today=self.today)

    def daily_mask(self, start_date=None, end_date=None):
        return daily_mask(self.get_bounds(start_date, end_date), today=self.today)

    def ycal_workdays_mask(self, start_date=None, end_date=None):
        return ycal_workdays_mask(self.get_bounds(start_date, end_date), self.country, today=self.today)

    def ycal_weekends_and_holidays_mask(self, start_date=None, end_date=None):
        """
        Праздники и выходные
        :param start_date:
        :param end_date:
        :return:
        """
        return ycal_weekends_and_holidays_mask(self.get_bounds(start_date, end_date), self.country, today=self.today)

    def ycal_holidays_mask(self, start_date=None, end_date=None):
        """
        Праздники
        :param start_date:
        :param end_date:
        :return:
        """
        return ycal_holidays_mask(self.get_bounds(start_date, end_date), self.country, today=self.today)

    def through_the_day_mask(self, start_date, end_date=None, schedule_start_date=None):
        return self.gap_days_mask(1, start_date, end_date, schedule_start_date)

    def gap_days_mask(self, days_in_gap, start_date, end_date=None, schedule_start_date=None):
        bounds = self.get_bounds(start_date, end_date)
        first_day = schedule_start_date or start_date

        return gap_days_mask(bounds, days_in_gap, first_day=first_day, today=self.today)

    def mask_from_day_condition(self, condition, start_date=None, end_date=None):
        return mask_from_day_condition(self.get_bounds(start_date, end_date), condition, today=self.today)

    def one_day_mask(self, date_, start_date=None, end_date=None):
        return one_day_mask(self.get_bounds(start_date, end_date), date_, today=self.today)
