# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from common.utils.calendar_matcher import YCalendar

from common.utils.exceptions import SimpleUnicodeException
from travel.rasp.rasp_scripts.scripts.pathfinder.mask_builder.standard_builders import mask_from_day_condition


class CountryRequiredError(SimpleUnicodeException):
    pass


def make_days_tester(days):
    def days_tester(day):
        return day in days
    return days_tester


def _check_country(country):
    if not country or not country._geo_id:
        raise CountryRequiredError('Нужно передавать страну с заполненным _geo_id')


def ycal_workdays_mask(bounds, country, today=None):
    """
    :type bounds: MaskBounds
    :type country: common.models.geo.Country
    :type today: date | None
    :rtype: RunMask
    """
    _check_country(country)

    include_days = YCalendar.get_workdays(bounds.start_date, bounds.end_date, country)

    return mask_from_day_condition(bounds, make_days_tester(include_days), today)


def ycal_weekends_and_holidays_mask(bounds, country, today=None):
    """
    Праздники и выходные
    :type bounds: MaskBounds
    :type country: common.models.geo.Country
    :type today: date | None
    :rtype: RunMask
    """
    _check_country(country)

    include_days = YCalendar.get_weekends(bounds.start_date, bounds.end_date, country)

    return mask_from_day_condition(bounds, make_days_tester(include_days), today)


def ycal_holidays_mask(bounds, country, today=None):
    """
    Праздники
    :type bounds: MaskBounds
    :type country: common.models.geo.Country
    :type today: date | None
    :rtype: RunMask
    """
    _check_country(country)

    include_days = YCalendar.get_holidays(bounds.start_date, bounds.end_date, country)

    return mask_from_day_condition(bounds, make_days_tester(include_days), today)
