# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.conf import settings

from datetime import timedelta

from common.data_api.file_wrapper.projects_configs.admin_mds_utils import get_instance_mds_prefix, MDS_TEMPORARY
from common.db.mds.clients import mds_s3_common_client
from common.settings.utils import define_setting
from travel.rasp.library.python.common23.date.environment import now_aware

log = logging.getLogger(__name__)

define_setting('TEMPORARY_SCHEDULE_PAST_DAYS', default=31 * 2)


class ScheduleMdsCleaner(object):
    def __init__(self, mds_client=mds_s3_common_client):
        self.mds_client = mds_client

    def clean(self, prefix, days):
        last_day = now_aware() - timedelta(days=days)
        old_keys = []

        keys = self.mds_client.get_prefix_keys(prefix=prefix)
        for key in keys:
            if key['LastModified'] < last_day:
                old_keys.append({'Key': key['Key']})

        if old_keys:
            deleted_keys = self.mds_client.delete_keys(old_keys)

            log.info('Deleted keys:')
            for d_k in deleted_keys:
                log.info(d_k['Key'])


def run(mds_prefix=None, past_days=None):
    log.info('raw: mds_prefix={}; past_days={}'.format(mds_prefix, past_days))

    past_days = past_days or settings.TEMPORARY_SCHEDULE_PAST_DAYS
    mds_prefix = mds_prefix or get_instance_mds_prefix(MDS_TEMPORARY)

    log.info('mds_prefix={}; past_days={}'.format(mds_prefix, past_days))

    cleaner = ScheduleMdsCleaner()
    cleaner.clean(prefix=mds_prefix, days=past_days)

    log.info('Done')
