# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime
from typing import AnyStr, List

from attr import attrs, attrib, asdict


DATETIME_FORMAT = '%d.%m.%y %H:%M'


def parse_datetime(dt_str):
    return datetime.strptime(dt_str, DATETIME_FORMAT)


@attrs(frozen=True)
class Destination(object):
    id = attrib(type=AnyStr)
    name = attrib(type=AnyStr)


@attrs(frozen=True)
class Passage(object):
    id = attrib(type=AnyStr)
    name = attrib(type=AnyStr)
    statement = attrib(type=int, converter=int)
    atp = attrib(type=AnyStr)
    busmark = attrib(type=AnyStr)
    bustype = attrib(type=AnyStr)
    totalseats = attrib(type=int, converter=int)
    freeseats = attrib(type=int, converter=int)
    departure = attrib(type=datetime, converter=parse_datetime)
    arrival = attrib(type=datetime, converter=parse_datetime)
    tariff = attrib(type=AnyStr)
    preftariff = attrib(type=AnyStr)
    bagtariff = attrib(type=AnyStr)
    category = attrib(type=AnyStr)
    tranzit = attrib(type=int, converter=int)
    saleseatlist = attrib(type=List[int])
    search_dest_from = attrib(type=AnyStr)
    search_dest_to = attrib(type=AnyStr)

    def to_dict(self):
        res = asdict(self)
        res['departure'] = res['departure'].strftime(DATETIME_FORMAT)
        res['arrival'] = res['arrival'].strftime(DATETIME_FORMAT)
        return res
