# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import time
from datetime import datetime, timedelta
from hashlib import md5
from typing import AnyStr

from travel.rasp.rasp_scripts.scripts.schedule.krasnodar.models import Destination


def get_hash_key(s):
    return md5(s.encode('utf-8')).hexdigest()


def expire_at(dt):
    """
    return dt + 2 days in microseconds
    """
    # type (datetime) -> int
    expire_at = dt + timedelta(days=2)
    return int(time.mktime(expire_at.timetuple()) * 1000000)


def get_cache_key(dt, av, destination):
    # type: (datetime, Destination, Destination) -> AnyStr
    return "{};{};{}".format(dt.strftime('%Y-%m-%d'), av.id, destination.id)
