# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from rasp_vault.api import get_secret

from travel.rasp.library.python.common23.db.replica_checker import RaspMainReplicaChecker, RaspReplicaChecker
from travel.rasp.library.python.common23.db.backends.cluster_mdb.fallback_hosts_mds import update_mdb_clusters_info_in_mds


log = logging.getLogger(__name__)

prod_main_checker = RaspMainReplicaChecker(
    user=get_secret('rasp-common-production.MYSQL_MDB_MAIN_USER'),
    password=get_secret('rasp-common-production.MYSQL_MDB_MAIN_PASSWORD'),
    database='rasp'
)

prod_maintenance_checker = RaspReplicaChecker(
    user=get_secret('rasp-common-production.MYSQL_MDB_MAIN_USER'),
    password=get_secret('rasp-common-production.MYSQL_MDB_MAIN_PASSWORD'),
    database='rasp_maintenance'
)

prod_rzd_checker = RaspReplicaChecker(
    user=get_secret('rasp-rzd-buffer-production.RASP_MDB_RZD_DB_USER'),
    password=get_secret('rasp-rzd-buffer-production.RASP_MDB_RZD_DB_PASSWORD'),
    database='rasp_rzd'
)

test_main_checker = RaspMainReplicaChecker(
    user=get_secret('rasp-common-testing.MYSQL_MDB_MAIN_USER'),
    password=get_secret('rasp-common-testing.MYSQL_MDB_MAIN_PASSWORD'),
    database='rasp'
)

test_maintenance_checker = RaspReplicaChecker(
    user=get_secret('rasp-common-testing.MYSQL_MDB_MAIN_USER'),
    password=get_secret('rasp-common-testing.MYSQL_MDB_MAIN_PASSWORD'),
    database='rasp_maintenance'
)

test_rzd_checker = RaspReplicaChecker(
    user=get_secret('rasp-rzd-buffer-testing.RASP_MDB_RZD_DB_USER'),
    password=get_secret('rasp-rzd-buffer-testing.RASP_MDB_RZD_DB_PASSWORD'),
    database='rasp_rzd'
)

MDB_CLUSTERS = (
    {"cluster_id": "mdb24grou1802opmsog4",  "cluster_name": "prod_main0", "replica_checker": prod_main_checker},
    {"cluster_id": "mdbclh89qe13gd9m89j6",  "cluster_name": "prod_main1", "replica_checker": prod_main_checker},
    {"cluster_id": "mdb2a3i1cgi24imbccb2",  "cluster_name": "prod_maintenance", "replica_checker": prod_maintenance_checker},
    {"cluster_id": "mdbcuhkeqi57nh45epdq",  "cluster_name": "prod_rzd_content", "replica_checker": prod_rzd_checker},

    {"cluster_id": "mdbkvsia8csfvukjqp0i",  "cluster_name": "stress_main01"},
    {"cluster_id": "mdbc9mvfjnur29kbi490",  "cluster_name": "stress_maintenance"},

    {"cluster_id": "mdbt1ohi1g9n83pklt36",  "cluster_name": "test_main0", "replica_checker": test_main_checker},
    {"cluster_id": "mdbjudnuiaptja63t6h0",  "cluster_name": "test_main1", "replica_checker": test_main_checker},
    {"cluster_id": "mdb8dr1jd2tvfjpcrhqs",  "cluster_name": "test_maintenance", "replica_checker": test_maintenance_checker},
    {"cluster_id": "mdbt2lcongp528h2htaa",  "cluster_name": "test_rzd_content", "replica_checker": test_rzd_checker},
)


def run():
    replica_checkers = [
        prod_main_checker,
        prod_maintenance_checker,
        prod_rzd_checker,
        test_rzd_checker,
        test_main_checker,
        test_maintenance_checker
    ]

    blacklist = get_secret('rasp-common.MDB_MYSQL_REPLICA_BLACKLIST', '').split(',')
    for replica_checker in replica_checkers:
        replica_checker.set_suspended_replicas(blacklist)

    log.info("Set suspended replicas: {}".format(blacklist))

    update_mdb_clusters_info_in_mds(MDB_CLUSTERS)


if __name__ == '__main__':
    run()
