# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
import tempfile

from common.settings import *  # noqa
from common.settings.configuration import BaseConfigurator, Configuration
from common.settings.utils import use_master_only

INSTALLED_APPS = COMMON_CONTRIB_APPS + COMMON_INSTALLED_APPS + ['route_search']  # noqa

SERVICE_INSTANCE = os.getenv('RASP_SERVICE_INSTANCE', False)

if SERVICE_INSTANCE:
    INSTANCE_ROLE = ServiceInstance  # noqa
else:
    INSTANCE_ROLE = WorkInstance  # noqa

PRELOAD_MAPPING_GEOMETRY = True
GEOMETRY_BASE_PATH = os.getenv('GEOMETRY_BASE_PATH', 'geometry')
EXPORT_URBAN_PUBLIC_PATH = os.getenv('EXPORT_URBAN_PUBLIC_PATH ', 'long_haul')


# Каталог данных для пересадочника
PATHFINDER_DATA_PATH = os.getenv('PATHFINDER_DATA_PATH', 'pathfinder_core_data')

PATHFINDER_MAPS_NEAREST_SETTLEMENT_FILENAME = os.getenv(
    'PATHFINDER_MAPS_NEAREST_SETTLEMENT_FILENAME',
    'pathfinder_maps_nearest_settlement.bin'
)

PRECACHE_MANAGERS = [
    'common.models.geo:Station.code_manager',
    'common.models.geo:StationType.objects',
    'common.models.geo:StationMajority.objects',
    'common.models.transport:TransportType.objects',
    'common.models.transport:TransportSubtype.objects',
    'common.models.transport:TransportSubtypeColor.objects',
    'common.models.geo:Settlement.objects',
    'common.models.schedule:Supplier.objects',
    'common.models.schedule:RThreadType.objects'
]

MYSQL_READ_TIMEOUT = MYSQL_WRITE_TIMEOUT = 3600 * 5

YT_PROXY = 'hahn.yt.yandex.net'
YT_SEARCH_LOG_PATH = '//home/rasp/logs/rasp-users-search-log'
YT_ROOT_PATH = '//home/rasp/rasp/min_price'
YT_LOG_PATH = '//home/rasp/logs'

AEROEX_CRT = 'aero.crt'
AEROEX_KEY = 'aero.key'

SCRIPTS_SOLOMON_PUSH_ENABLED = False


class RaspScriptsConfigurator(BaseConfigurator):
    def try_set_master_only(self, settings):
        if os.getenv('RASP_MASTER_ONLY', False):
            use_master_only(settings)

    def apply_base(self, settings):
        for database in settings['MONGO_DATABASES'].values():
            database.setdefault('options', {}).update({
                'socketTimeoutMS': None,
                'connectTimeoutMS': 20000,
                'serverSelectionTimeoutMS': 30000
            })

    def apply_testing(self, settings):
        self.try_set_master_only(settings)
        settings['AEROEX_CRT_SECRET'] = 'rasp-suburban-selling-testing.AEROEX_CRT'
        settings['AEROEX_KEY_SECRET'] = 'rasp-suburban-selling-testing.AEROEX_KEY'

    def apply_production(self, settings):
        self.try_set_master_only(settings)
        settings['AEROEX_CRT_SECRET'] = 'rasp-suburban-selling-production.AEROEX_CRT'
        settings['AEROEX_KEY_SECRET'] = 'rasp-suburban-selling-production.AEROEX_KEY'


Configuration.configurator_classes = [
    'mysql',
    'mongo_all',
    'misc',
    'replica_state_cache',
    'rasp_backend',
    RaspScriptsConfigurator
]

# common log settings
LOG_PATH = tempfile.gettempdir()
LOG_FORMAT = '%(levelname)s %(asctime)s %(process)d %(name)s %(message)s'
