PY2_LIBRARY(rasp_scripts)

OWNER(
    g:rasp-back
)

PEERDIR(
    yql/library/python
    yt/python/client

    travel/library/python/entrypoint
    travel/library/python/rasp_vault
    travel/proto/dicts/rasp
    travel/rasp/library/python/api_clients/chelyabinsk_bus
    travel/rasp/library/python/api_clients/krasnodar_bus
    travel/rasp/library/python/api_clients/market_cms
    travel/rasp/library/python/common
    travel/rasp/library/python/mapping
    travel/rasp/library/python/route_search
    travel/rasp/library/python/ydb
)

PY_SRCS(
    load_project.py
    settings.py
    tests_settings.py
    bin/local_settings.py

    scripts/gen_pathfinder_maps_nearest_settlements.py
    scripts/generate_archival_data.py
    scripts/generate_im_grouped_data.py
    scripts/generate_journal_sitemap.py
    scripts/gen_railway_data.py
    scripts/fill_livemap.py
    scripts/limepaths_pack_data.py

    scripts/long_haul/cache_export.py
    scripts/long_haul/export/__init__.py
    scripts/long_haul/export/base.py
    scripts/long_haul/export/formatters.py
    scripts/long_haul/export/generators.py
    scripts/long_haul/export/utils.py
    scripts/long_haul/export/v2_5.py
    scripts/long_haul/export/v2_6.py
    scripts/long_haul/export/validation.py

    scripts/suburban/compare_provider_report_with_billing.py

    scripts/pathfinder/gen_baris_thegraph.py
    scripts/pathfinder/gen_maps.py
    scripts/pathfinder/gen_pathfinder_data.py
    scripts/pathfinder/gen_rasp_db_thegraph.py
    scripts/pathfinder/helpers.py
    # copied from admin for gen_pathfinder tests
    scripts/pathfinder/mask_builder/bounds.py
    scripts/pathfinder/mask_builder/mask_builders.py
    scripts/pathfinder/mask_builder/standard_builders.py
    scripts/pathfinder/mask_builder/ycal_builders.py
    scripts/pathfinder/min_prices_from_logs/dump_yt_price_to_pathfinder.py
    scripts/pathfinder/originalbox.py
    scripts/pathfinder/tmpfiles.py

    scripts/schedule/chelyabinsk.py
    scripts/schedule/odnakassa.py

    scripts/schedule/krasnodar/__init__.py
    scripts/schedule/krasnodar/availiable_avs.py
    scripts/schedule/krasnodar/krasnodar_bus_builder.py
    scripts/schedule/krasnodar/krasnodar_bus_parser.py
    scripts/schedule/krasnodar/krasnodar_cache.py
    scripts/schedule/krasnodar/models.py
    scripts/schedule/krasnodar/storages.py
    scripts/schedule/krasnodar/utils.py
    scripts/schedule/clean_temporary_schedule.py

    scripts/script_example.py
    scripts/update_mdb_hosts.py
)

NO_CHECK_IMPORTS()

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
    bin/tests
)
