#pragma once

#include "config.h"
#include "flight_status.h"
#include "rasp_search_index.h"
#include "station_segments_index.h"

#include <algorithm>

namespace NRasp {
    using TAirportPanelFlights = std::pair<TFlights, TFlights>;

    class TAirportPanel {
    public:
        TAirportPanel(
            const TRaspSearchIndex& searchIndex,
            const TStationSegmentsIndex& stationSegmentsIndex,
            const TFlightStatusesConfig& statusesConfig)
            : SearchIndex(searchIndex)
            , StationSegmentsIndex(stationSegmentsIndex)
            , StatusesLimit{statusesConfig.QueryLimit}
            , AllowedStationIds{statusesConfig.AllowedStationIds}
            , StatusesFetcher{statusesConfig.Source, statusesConfig.TimeoutMilliseconds} {
        }

        TAirportPanelFlights FindFlights(const TStationQuery& query) const;

    private:
        TFlights FetchFlights(
            const TStationWrapper& airport,
            const TSegmentsWithRange& segmentsWithRange,
            ui16 segmentsLimit,
            TCommonSegmentFinder::EEventType eventType) const;

        void FilterFlights(
            TFlights& flights,
            const TFlightEventInstantGetter& getEventInstant,
            const TInstant& minEventInstant,
            const TInstant& maxEventInstant) const;

        TFlights MakeFlightsWithoutStatuses(const TSegmentsWithRange& segmentsWithRange) const;

    private:
        const TRaspSearchIndex& SearchIndex;
        const TStationSegmentsIndex& StationSegmentsIndex;
        ui16 StatusesLimit;
        THashSet<object_id_t> AllowedStationIds;
        TFlightStatusFetcher StatusesFetcher;
    };
}
