#pragma once

#include <travel/rasp/route-search-api/proto/rthread.pb.h>

#include <library/cpp/json/json_value.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/langs/langs.h>

#include <util/generic/hash_set.h>
#include <util/generic/hash.h>
#include <util/stream/file.h>

#include "travel/rasp/route-search-api/helpers.h"

namespace NRasp {
    class TLanguageConfig {
    public:
        TLanguageConfig() = default;
        TLanguageConfig(const TString& defaultLanguage, const TVector<TString>& languages);

        ELanguage GetDefault() const;
        ELanguage Get(const TString& lang) const;

        static const THashMap<TString, std::function<TString(TString, ELanguage)>>& GetTranslations();

    private:
        ELanguage DefaultLanguage;
        THashMap<TString, ELanguage> Languages;
    };

    class THostConfig {
    public:
        THostConfig(){};
        void AddHost(bool isMobile, const TString& host, const TString& tld);
        const TString& GetHostByTld(bool isMobile, const TString& tld) const;

    private:
        THashMap<TString, TString> MobileHostByTld;
        THashMap<TString, TString> DesktopHostByTld;
    };

    struct TFlightStatusesConfig {
        ui16 QueryLimit{0};
        ui16 TimeoutMilliseconds{0};
        TString Source;
        THashSet<object_id_t> AllowedStationIds;
    };

    struct TConfig {
        TString DumpDirectory;

        ui16 Port;
        ui16 Threads;
        TString CurrencyRateSource;
        TTransportSet TransportTypes;
        TLanguageConfig LanguageConfig;
        THostConfig HostConfig;
        bool StationSegmentsIndex;
        TFlightStatusesConfig FlightStatusesConfig;

        static TConfig FromJson(const NJson::TJsonValue& params);

        static TConfig FromFile(const TString& path);

    private:
        static const THashMap<TString, TRThread::ETransportType> Types;
    };
}
